uniform float radius;
uniform vec2 position; //beacon position in screen coords
uniform float time;
uniform float burning;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(1.29898,.78233))) * 43758.5453);
}

void main()
{
	vec4 color = vec4(0.,0.,0.,1.);
	
	float factor = length(gl_FragCoord.xy - position) / radius;
	//factor < 1: in the radius we leave color unchanged.
	//factor > 1: linear falloff until 0.
	factor = floor(1.1-clamp(factor, 0.0, 1.0));

	color.rgb = vec3(factor,factor,factor);

	gl_FragColor = color;
//	gl_FragColor = crepuscularRays(gl_FragCoord.xy, gl_TexCoord[0].xy, position, color);
}
